% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_grapheme.R
\name{create_grapheme}
\alias{create_grapheme}
\title{Create a grapheme instance}
\usage{
create_grapheme(
  symbol,
  response_times = NULL,
  response_colors,
  color_space_spec = "Luv"
)
}
\arguments{
\item{symbol}{A one-element character vector holding a symbol/grapheme.}

\item{response_times}{(optional) A numeric vector. Times from presentation to
response, in order.}

\item{response_colors}{A character vector. Response colors, as hex color
codes.}

\item{color_space_spec}{A one-element character vector. What color space
is to be used? The following color spaces are supported:
"XYZ", "sRGB", "Apple RGB", "Lab", and "Luv"}
}
\description{
Takes in a symbol/grapheme and sets of response times/colors,
then creates a Grapheme instance that holds the passed information and returns it.
}
\examples{
create_grapheme(symbol="a", response_times=c(2.3, 6.7, 0.4),
response_colors=c("84AE99", "9E3300", "000000"), color_space_spec="Luv")
}
