% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys_iter.R
\name{sys_iter}
\alias{sys_iter}
\title{Obtain the transition probability of each iteration}
\usage{
sys_iter(binary_dataset, n_iter, vars_to_discretize = NULL)
}
\arguments{
\item{binary_dataset}{A binary dataframe of datasets used to establish evaluation criteria.}

\item{n_iter}{The number of iterations to reach the steady state.}

\item{vars_to_discretize}{Variables or columns to be discretized. Default id NULL.}
}
\value{
A dataframe containing the number of iterations and the transition probability of each iteration.
}
\description{
Loop "n_iter" times to obtain the transition probability of each iteration.
}
\examples{
data(dataset)
iter_prob <- sys_iter(dataset, 6, c("Shape", "pH"))
}
