% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syslog.R
\name{syslog}
\alias{syslog}
\title{Send log message to syslog server}
\usage{
syslog(
  message,
  severity = "NOTICE",
  facility = "USER",
  host = Sys.info()[["nodename"]],
  app_name = Sys.info()[["user"]],
  proc_id = Sys.getpid(),
  server = "localhost",
  port = 601L
)
}
\arguments{
\item{message}{text message (string).}

\item{severity}{severity level (string).}

\item{facility}{log facility (string).}

\item{host}{machine that originally sends the message (string).}

\item{app_name}{application name that originally sends the message (string).}

\item{proc_id}{process id that originally sends the message (numeric).}

\item{server}{syslogd server hostname (string).}

\item{port}{syslogd server port (integer).}
}
\value{
Number of bytes written to socket.
}
\description{
Send log message to syslog server.
}
\examples{
\dontrun{
syslog("log message", "INFO", app_name = 'program', server = 'logserver')
}
}
