% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum.R
\name{.sum}
\alias{.sum}
\title{Summarise groups of rows or columns}
\usage{
.sum(..., character = NULL, numeric = NULL)
}
\arguments{
\item{...}{[\code{integerish(1)}]\cr columns or rows that shall be combined.
If there are several items provided, they will be summarised into one group
that is combined according to its type and the respective function provided
in \code{character} or \code{numeric}.}

\item{character}{[\code{function(1)}]\cr function by which character columns
or rows shall be combined.}

\item{numeric}{[\code{function(1)}]\cr function by which numeric columns or
rows shall be combined.}
}
\value{
the index values where the target was found.
}
\description{
Summarise groups of rows or columns
}
\details{
By default \code{character} values are summarised with the function
  \code{paste0(na.omit(x), collapse = "-/-")} and \code{numeric} values with
  the function \code{sum(x, na.rm = TRUE)}. To avoid un-intuitive behavior,
  it is wisest to explicitly specify how all exceptions, such as NA-values,
  shall be handled and thus to provide a new function.
}
