% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/resample.R
\docType{methods}
\name{simulate}
\alias{simulate}
\alias{simulate,DiversityIndex-method}
\title{Measure Diversity by Comparing to Simulated Assemblages}
\usage{
\S4method{simulate}{DiversityIndex}(
  object,
  nsim = 1000,
  seed = NULL,
  step = 1,
  level = 0.8,
  interval = "percentiles",
  progress = getOption("tabula.progress"),
  ...
)
}
\arguments{
\item{object}{A \linkS4class{DiversityIndex} object.}

\item{nsim}{A non-negative \code{\link{integer}} specifying the number of simulations.}

\item{seed}{An object specifying if and how the random number generator
should be initialized (see \code{\link[stats:simulate]{stats::simulate()}}).}

\item{step}{An \code{\link{integer}} giving the increment of the sample size.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{interval}{A \code{\link{character}} string giving the type of confidence
interval to be returned. Currently, only "\code{percentiles}" is supported
(sample quantiles, as described in Kintigh 1984)..}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}

\item{...}{Currently not used.}
}
\value{
Returns a \linkS4class{DiversityIndex} object.
}
\description{
Measure Diversity by Comparing to Simulated Assemblages
}
\examples{
\donttest{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Assemblage diversity size comparison
## Warning: this may take a few seconds!
h <- heterogeneity(cantabria, method = "shannon")
h_sim <- simulate(h)
plot(h_sim)

r <- richness(cantabria, method = "observed")
r_sim <- simulate(r)
plot(r_sim)
}
}
\references{
Baxter, M. J. (2001). Methodological Issues in the Study of Assemblage
Diversity. \emph{American Antiquity}, 66(4), 715-725. \doi{10.2307/2694184}.

Kintigh, K. W. (1984). Measuring Archaeological Diversity by Comparison
with Simulated Assemblages. \emph{American Antiquity}, 49(1), 44-54.
\doi{10.2307/280511}.
}
\seealso{
\code{\link[=bootstrap]{bootstrap()}}, \code{\link[=jackknife]{jackknife()}}

Other diversity measures: 
\code{\link{diversity}()},
\code{\link{evenness}()},
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot.DiversityIndex}()},
\code{\link{plot.RarefactionIndex}()},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
