% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{laventa}
\alias{laventa}
\title{Geochronology samples from the Honda Group in Colombia}
\format{
A data frame with 87 rows and 7 variables:
\describe{
\item{age}{Estimated age (in Ma) from a given rock sample}
\item{one_sigma}{Standard deviation of the age estimate}
\item{sample}{Sample code as in Table 3.2}
\item{unit}{Stratigraphic unit in either the Honda Group or the
            Huila Group}
\item{elevation}{Position in the stratigraphic column, in meters}
\item{mineral}{The mineral used for dating the sample}
\item{comments}{Comments from footnotes in the original table}
}
}
\usage{
data(laventa)
}
\description{
A dataset containing geochronology data from several samples along
the stratigraphic column of the Honda and Huila groups in the Tatacoa
Desert area. The dataset was compiled from the Table 3.2 in Flynn et al.
(1997).
}
\references{
Flynn, J.J., Guerrero, J. & Swisher III, C.C. (1997) Geochronology of the Honda Group. In: R. F. Kay, R. H. Madden, R. L. Cifelli, and J. J. Flynn (Eds), Vertebrate Paleontology in the Neotropics: the Miocene Fauna of La Venta, Colombia. Smithsonian Institution Press, pp. 44–60.
}
\keyword{datasets}
