% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_card.R
\name{.convert_teal_card_input}
\alias{.convert_teal_card_input}
\title{Internal helper for `teal_card`` input conversion}
\usage{
.convert_teal_card_input(x)
}
\arguments{
\item{x}{(\code{object}) An object to be converted.}
}
\value{
The processed object, possibly converted or left unchanged.
}
\description{
Converts input values to a format compatible with \code{teal_card}.
This function is used internally to handle common inputs, such as \code{ggplot} objects,
ensuring they are appropriately converted to an "evaluable output" blocks that can
be saved to \code{RDS} file efficiently.
}
\details{
This function performs the following conversions:
\itemize{
\item \code{ggplot} objects are converted to \code{recordedplot} objects.
}

If the R option \code{teal.reporter.disable_teal_card_conversion} is set to \code{TRUE},
no conversion is applied.
}
\keyword{internal}
