% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_report_button}
\alias{download_report_button}
\alias{download_report_button_ui}
\alias{download_report_button_srv}
\title{Download report button module}
\usage{
download_report_button_ui(id, label = NULL)

download_report_button_srv(
  id,
  reporter,
  global_knitr = getOption("teal.reporter.global_knitr"),
  rmd_output = getOption("teal.reporter.rmd_output"),
  rmd_yaml_args = getOption("teal.reporter.rmd_yaml_args")
)
}
\arguments{
\item{id}{(\code{character(1)}) this \code{shiny} module's id.}

\item{label}{(\code{character(1)}) label of the button. By default it is empty.}

\item{reporter}{(\code{Reporter}) instance.}

\item{global_knitr}{(\code{list}) of \code{knitr} parameters (passed to \code{knitr::opts_chunk$set})
for customizing the rendering process.}

\item{rmd_output}{(\code{character}) vector with \code{rmarkdown} output types,
by default all possible \code{pdf_document}, \code{html_document}, \code{powerpoint_presentation}, and \code{word_document}.
If vector is named then those names will appear in the \code{UI}.}

\item{rmd_yaml_args}{(\verb{named list}) with \code{Rmd} \code{yaml} header fields and their default values.
This \code{list} will result in the custom subset of UI inputs for the download reporter functionality.
Default \code{list(author = "NEST", title = "Report", date = Sys.Date(), output = "html_document", toc = FALSE)}.
The \code{list} must include at least \code{"output"} field.
The default value for \code{"output"} has to be in the \code{rmd_output} argument.}
}
\value{
\code{NULL}.
}
\description{
Provides a button that triggers downloading a report.

For more information, refer to the vignette: \code{vignette("simpleReporter", "teal.reporter")}.
}
\details{
To access the default values for the \code{global_knitr} parameter,
use \code{getOption('teal.reporter.global_knitr')}. These defaults include:
\itemize{
\item \code{echo = TRUE}
\item \code{tidy.opts = list(width.cutoff = 60)}
\item \code{tidy = TRUE}  if \code{formatR} package is installed, \code{FALSE} otherwise
}
}
