% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{PoR_stress2grid}
\alias{PoR_stress2grid}
\alias{PoR_stress2grid_stats}
\title{Spatial Interpolation of SHmax in PoR Coordinate Reference System}
\usage{
PoR_stress2grid(
  x,
  PoR,
  grid = NULL,
  PoR_grid = TRUE,
  lon_range = NULL,
  lat_range = NULL,
  gridsize = 2.5,
  remove_PoR = FALSE,
  ...
)

PoR_stress2grid_stats(
  x,
  PoR,
  grid = NULL,
  PoR_grid = TRUE,
  lon_range = NULL,
  lat_range = NULL,
  gridsize = 2.5,
  remove_PoR = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{sf} object containing
\describe{
\item{azi}{SHmax in degree}
\item{unc}{Uncertainties of SHmax in degree}
\item{type}{Methods used for the determination of the orientation of SHmax}
}}

\item{PoR}{Pole of Rotation. \code{data.frame} or object of class
\code{"euler.pole"} containing the geographical coordinates of the Euler pole}

\item{grid}{(optional) Point object of class \code{sf}.}

\item{PoR_grid}{logical. Whether the grid should be generated based on the
coordinate range in the PoR (\code{TRUE}, the default) CRS or the geographical CRS
(\code{FALSE}). Is ignored if \code{grid} is specified.}

\item{lon_range, lat_range}{(optional) numeric vector specifying the minimum
and maximum longitudes and latitudes (are ignored if \code{grid} is specified).}

\item{gridsize}{Numeric. Target spacing of the regular grid in decimal
degree. Default is 2.5 (is ignored if \code{grid} is specified)}

\item{remove_PoR}{logical. Whether PoR azimuths and coordinates will be
removed from final output or not (the default.)}

\item{...}{Arguments passed to \code{\link[=stress2grid]{stress2grid()}}}
}
\value{
\code{sf} object containing
\describe{
\item{lon,lat}{longitude and latitude in geographical CRS (in degrees)}
\item{lon.PoR,lat.PoR}{longitude and latitude in PoR CRS (in degrees).
Only if \code{remove_PoR=TRUE}}
\item{azi}{geographical mean SHmax in degree}
\item{azi.PoR}{PoR mean SHmax in degree. Only if \code{remove_PoR=TRUE}}
\item{sd}{Standard deviation of SHmax in degrees}
\item{R}{Search radius in km}
\item{mdr}{Mean distance of datapoints per search radius}
\item{N}{Number of data points in search radius}
}
}
\description{
The data is transformed into the PoR system before the
interpolation. The interpolation grid is returned in geographical coordinates
and azimuths.
}
\details{
Stress field and wavelength analysis in PoR system and back-transformed
}
\examples{
data("san_andreas")
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
PoR_stress2grid(san_andreas, PoR) |> head()

\dontrun{
PoR_stress2grid_stats(san_andreas, PoR, mode = TRUE) |> head()
}
}
\seealso{
\code{\link[=stress2grid]{stress2grid()}}, \code{\link[=compact_grid]{compact_grid()}}
}
