% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotTensorBF}
\alias{plotTensorBF}
\title{Plot Tensor Components}
\usage{
plotTensorBF(res, Y = NULL, k = 1, modesOnAxis = c(1, 2, 3),
  nTopFeatures = c(5, 15, 3), margins = c(4, 4, 4, 12), cex.axis = 1,
  cols = colorRampPalette(c("blue", "white", "red"))(101), key = TRUE,
  plimit = NULL)
}
\arguments{
\item{res}{The learned tensorBF model.}

\item{Y}{The original input data to be plotted. If specified NULL,
the function plots the data reconstruction using \code{\link{reconstructTensorBF}} (default: NULL).}

\item{k}{the component number to visualize (default: 1).}

\item{modesOnAxis}{which mode to plot on each axis c(Yaxis,Xaxis,lateral). Defaults to c(1,2,3).}

\item{nTopFeatures}{The number of most relevant features to show for the data space
visualizations in each of the modes. Defaults to c(5,15,3) for displaying top 10 features
of \eqn{1^{st}} mode, 20 of \eqn{2^{nd}} mode and 5 of \eqn{3^{rd}} mode.}

\item{margins}{numeric vector of length 4 containing the margins (see par(mar= *))}

\item{cex.axis}{positive numbers, used as cex.axis (default: 1)}

\item{cols}{colors used for the image. Defaults to a blue-white-red color scale.}

\item{key}{logical indicating whether a color-key should be drawn.}

\item{plimit}{(optional) numerical number indicating the maximum absolute value to be plotted in the heatmap.}
}
\description{
\code{plotTensorBF} shows the heatmap of components inferred by \code{\link{tensorBF}}.
}
\examples{
#Data generation
K <- 3
X <- matrix(rnorm(20*K),20,K)
W <- matrix(rnorm(30*K),30,K)
U <- matrix(rnorm(3*K),3,K)
Y = 0
for(k in 1:K) Y <- Y + outer(outer(X[,k],W[,k]),U[,k])
 Y <- Y + array(rnorm(20*30*3,0,0.25),dim=c(20,30,3))

#Run the method with default options
\dontrun{res1 <- tensorBF(Y)}
\dontrun{plotTensorBF(res = res1,Y=Y,k=1)}
}
