% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td_uniformity.R
\name{td_uniformity}
\alias{td_uniformity}
\title{Test of uniformity of terminal digits}
\usage{
td_uniformity(x, decimals, reps = 10000, tolerance = 64 * .Machine$double.eps)
}
\arguments{
\item{x}{a numeric vector}

\item{decimals}{an integer specifying the number of decimals. This can be zero if the terminal digit is
not a decimal.}

\item{reps}{a positive integer specifying the number of Monte Carlo simulations. The default
is set to 10,000.}

\item{tolerance}{sets an upper bound for rounding errors when evaluating
whether a statistic for a simulation is greater than or equal to the
statistic for the observed data. The default is identical to the tolerance
set for simulations in the \code{chisq.test} function from the \code{stats}
package in R.}
}
\value{
A list containing the following components:

\item{statistic}{the value of the test statistic}
\item{p_value}{the simulated p-value for the test}
\item{method}{a character string describing the test}
\item{data.name}{a character string give the name of the data}
}
\description{
The \code{td_uniformity} function tests the uniformity of terminal digits via
Pearson's chi-squared test of goodness-of-fit. Rather than relying on the asymptotic
approximation to the chi-squared distribution, \code{td_unformity} uses the \code{chisq_gof}
function from the \code{discretefit} package to simulate the distribution under the null.
}
\examples{

td_uniformity(decoy$weight, decimals = 2, reps = 2000)


}
