% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_average_model_checkpoint}
\alias{callback_average_model_checkpoint}
\title{Average Model Checkpoint}
\usage{
callback_average_model_checkpoint(
  filepath,
  update_weights,
  monitor = "val_loss",
  verbose = 0,
  save_best_only = FALSE,
  save_weights_only = FALSE,
  mode = "auto",
  save_freq = "epoch",
  ...
)
}
\arguments{
\item{filepath}{string, path to save the model file.}

\item{update_weights}{bool, wheteher to update weights or not}

\item{monitor}{quantity to monitor.}

\item{verbose}{verbosity mode, 0 or 1.}

\item{save_best_only}{if `save_best_only=TRUE`, the latest best model according
to the quantity monitored will not be overwritten. If `filepath` doesn't contain
formatting options like `{epoch}` then `filepath` will be overwritten by each new
better model.}

\item{save_weights_only}{if TRUE, then only the model's weights will be saved
(`model$save_weights(filepath)`), else the full model is saved (`model$save(filepath)`).}

\item{mode}{one of {auto, min, max}. If `save_best_only=TRUE`, the decision to
overwrite the current save file is made based on either the maximization or the
minimization of the monitored quantity. For `val_acc`, this should be `max`, for
`val_loss` this should be `min`, etc. In `auto` mode, the direction is automatically
inferred from the name of the monitored quantity.}

\item{save_freq}{`'epoch'` or integer. When using `'epoch'`, the callback saves the
model after each epoch. When using integer, the callback saves the model at end of a
batch at which this many samples have been seen since last saving. Note that if the
saving isn't aligned to epochs, the monitored metric may potentially be less reliable
(it could reflect as little as 1 batch, since the metrics get reset every epoch).
Defaults to `'epoch'`}

\item{...}{Additional arguments for backwards compatibility. Possible key is `period`.}
}
\value{
None
}
\description{
Save the model after every epoch.
}
\details{
The callback that should be used with optimizers that extend
AverageWrapper, i.e., MovingAverage and StochasticAverage optimizers.
It saves and, optionally, assigns the averaged weights.
}
\section{For example}{
 if `filepath` is `weights.{epoch:02d}-{val_loss:.2f}.hdf5`,:
then the model checkpoints will be saved with the epoch number and the validation loss in the filename.
}

