% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{layer_correlation_cost}
\alias{layer_correlation_cost}
\title{Correlation Cost Layer.}
\usage{
layer_correlation_cost(
  object,
  kernel_size,
  max_displacement,
  stride_1,
  stride_2,
  pad,
  data_format,
  ...
)
}
\arguments{
\item{object}{Model or layer object}

\item{kernel_size}{An integer specifying the height and width of the
patch used to compute the per-patch costs.}

\item{max_displacement}{An integer specifying the maximum search radius
for each position.}

\item{stride_1}{An integer specifying the stride length in the input.}

\item{stride_2}{An integer specifying the stride length in the patch.}

\item{pad}{An integer specifying the paddings in height and width.}

\item{data_format}{Specifies the data format. Possible values are:
"channels_last" float [batch, height, width, channels] "channels_first"
float [batch, channels, height, width] Defaults to "channels_last".}

\item{...}{additional parameters to pass}
}
\value{
A tensor
}
\description{
Correlation Cost Layer.
}
\details{
This layer implements the correlation operation from FlowNet
Learning Optical Flow with Convolutional Networks (Fischer et al.):
https://arxiv.org/abs/1504.06
}
