% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnn.R
\name{layer_norm_lstm_cell}
\alias{layer_norm_lstm_cell}
\title{LSTM cell with layer normalization and recurrent dropout.}
\usage{
layer_norm_lstm_cell(
  object,
  units,
  activation = "tanh",
  recurrent_activation = "sigmoid",
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  unit_forget_bias = TRUE,
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  dropout = 0,
  recurrent_dropout = 0,
  norm_gamma_initializer = "ones",
  norm_beta_initializer = "zeros",
  norm_epsilon = 0.001,
  ...
)
}
\arguments{
\item{object}{Model or layer object}

\item{units}{Positive integer, dimensionality of the output space.}

\item{activation}{Activation function to use. Default: hyperbolic tangent (`tanh`). If
you pass `NULL`, no activation is applied (ie. "linear" activation: `a(x) = x`).}

\item{recurrent_activation}{Activation function to use for the recurrent step.
Default: sigmoid (`sigmoid`). If you pass `NULL`, no activation is applied
(ie. "linear" activation: `a(x) = x`).}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the `kernel` weights matrix, used for the
linear transformation of the inputs.}

\item{recurrent_initializer}{Initializer for the `recurrent_kernel` weights matrix,
used for the linear transformation of the recurrent state.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{unit_forget_bias}{Boolean. If True, add 1 to the bias of the forget gate at initialization.
Setting it to true will also force `bias_initializer="zeros"`. This is
recommended in [Jozefowicz et al.](http://www.jmlr.org/proceedings/papers/v37/jozefowicz15.pdf)}

\item{kernel_regularizer}{Regularizer function applied to the `kernel` weights matrix.}

\item{recurrent_regularizer}{Regularizer function applied to the `recurrent_kernel` weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{kernel_constraint}{Constraint function applied to the `kernel` weights matrix.}

\item{recurrent_constraint}{Constraint function applied to the `recurrent_kernel` weights matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the linear transformation of the inputs.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop for the linear transformation of the recurrent state.}

\item{norm_gamma_initializer}{Initializer for the layer normalization gain initial value.}

\item{norm_beta_initializer}{Initializer for the layer normalization shift initial value.}

\item{norm_epsilon}{Float, the epsilon value for normalization layers.}

\item{...}{List, the other keyword arguments for layer creation.}
}
\value{
A tensor
}
\description{
LSTM cell with layer normalization and recurrent dropout.
}
\details{
This class adds layer normalization and recurrent dropout to a LSTM unit. Layer
normalization implementation is based on: https://arxiv.org/abs/1607.06450.
"Layer Normalization" Jimmy Lei Ba, Jamie Ryan Kiros, Geoffrey E. Hinton and is
applied before the internal nonlinearities.
Recurrent dropout is based on: https://arxiv.org/abs/1603.05118
"Recurrent Dropout without Memory Loss" Stanislau Semeniuta, Aliaksei Severyn, Erhardt Barth.
}
