% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_sparsemax}
\alias{loss_sparsemax}
\title{Sparsemax loss}
\usage{
loss_sparsemax(
  from_logits = TRUE,
  reduction = tf$keras$losses$Reduction$SUM_OVER_BATCH_SIZE,
  name = "sparsemax_loss"
)
}
\arguments{
\item{from_logits}{Whether y_pred is expected to be a logits tensor.
Default is True, meaning y_pred is the logits.}

\item{reduction}{(Optional) Type of tf$keras$losses$Reduction to apply
to loss. Default value is SUM_OVER_BATCH_SIZE.}

\item{name}{Optional name for the op.}
}
\value{
A `Tensor`. Has the same type as `logits`.
}
\description{
Sparsemax loss function [1].
}
\details{
Computes the generalized multi-label classification loss for the sparsemax
function. The implementation is a reformulation of the original loss
function such that it uses the sparsemax properbility output instead of the
internal au variable. However, the output is identical to the original
loss function. [1]: https://arxiv.org/abs/1602.02068
}
