% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_chart_functions.R
\name{column_chart_absolute_variance}
\alias{column_chart_absolute_variance}
\title{Generate column chart with absolute variance.}
\usage{
column_chart_absolute_variance(
  x,
  baseline,
  real,
  colors = 1,
  data = NULL,
  x_title = "PY",
  x_style = "previous",
  interval = "months"
)
}
\arguments{
\item{x}{vector containing labels for x axis or name of column in data with values of x axis labels}

\item{baseline}{vector containing base values or name of column in data with base values}

\item{real}{vector containing values that will be compared to baseline  or name of column in data with that values}

\item{colors}{1 if green color represents positive values having good business impact and red negative values having bad impact or 2 if otherwise}

\item{data}{data frame with columns containing data for x, baseline or real series}

\item{x_title}{the title of the plot}

\item{x_style}{style of the x axis to indicate baseline scenario. The default is 'previous'.}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
Visualize variance between two time series (baseline and real) in the same units as the time series. Choose colors parameter accordingly to business interpretation of larger/smaller values.
}
\examples{
x <- month.abb
baseline <- rnorm(12)
real <- c(rnorm(6, mean = -1), rnorm(6, mean = 1))
column_chart_absolute_variance(x, baseline, real, x_title = 'profit')
}
