% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_chart_functions.R
\name{column_chart_grouped}
\alias{column_chart_grouped}
\title{Generate grouped column chart for visualizing up to 3 data series.}
\usage{
column_chart_grouped(
  x,
  foreground,
  background,
  markers = NULL,
  data = NULL,
  series_labels,
  styles = NULL,
  interval = "months"
)
}
\arguments{
\item{x}{vector containing labels for x axis or name of column in data with values of x axis labels}

\item{foreground}{vector or name of column in data representing heights of bars visible in the foreground}

\item{background}{vector or name of column in data representing heights of bars visible in the background}

\item{markers}{optional vector representing position of triangles}

\item{data}{data frame in wide format containing data to be plotted}

\item{series_labels}{vector of series titles. Consists of 2 or 3 elements}

\item{styles}{optional dataframe of styles. First column contains styles for foreground series, second for background, third for triangles. dim(styles) must be length(x), length(titles)}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
Generate grouped column chart for visualizing up to 3 data series.
}
\examples{
df <- data.frame(x = month.abb[7:12],
                 actual = rnorm(6, mean = 5, sd = 0.3),
                 budget = rnorm(6, mean = 4.5, sd = 0.7),
                 prev_year = rnorm(6, mean = 4))

column_chart_grouped(x = df$x,
                     foreground = df$actual,
                     background = df$budget,
                     markers = df$prev_year,
                     series_labels = c('AC', 'BU', 'PY'))
}
