% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_chart_dense.R
\name{line_chart_dense}
\alias{line_chart_dense}
\title{Line chart with more points then categories on x-axis.}
\usage{
line_chart_dense(data, dates, series, interval = "months")
}
\arguments{
\item{data}{Data frame in wide format.}

\item{dates}{Name of column in `data` which contains dates or vector of dates.}

\item{series}{Vector of column names in `data` with values of time series.}

\item{interval}{Granularity of x axis. One of c('weeks', 'months', 'quarters', 'years'). Default value is 'months'.}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
Line chart with more points then categories on x-axis.
}
\examples{

df <- data.frame(
 x = seq.Date(as.Date('2021-01-01'), as.Date('2021-07-01'), length.out = 200),
 'Company_sin' = 5 * sin(seq(
   from = 0,
   to = 2 * pi,
   length.out = 200
   )) +  rnorm(200, mean = 5, sd = 0.5),
 'Company_cos' = 5 * cos(seq(
   from = 0,
   to = 2 * pi,
   length.out = 200
 )) +  rnorm(200, mean = 5, sd = 0.5))

df <- head(df, n = 199)

line_chart_dense(
  df,
  dates = 'x',
  series = c('Company_sin', 'Company_cos'))

}
