% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidydp.R
\name{dp_mean}
\alias{dp_mean}
\title{Differentially Private Mean}
\usage{
dp_mean(
  data,
  column,
  epsilon,
  delta = NULL,
  lower = NULL,
  upper = NULL,
  group_by = NULL,
  .budget = NULL
)
}
\arguments{
\item{data}{A data frame}

\item{column}{Column name to compute mean of}

\item{epsilon}{Privacy parameter}

\item{delta}{Privacy parameter (default: NULL, uses Laplace mechanism)}

\item{lower}{Lower bound of the data range}

\item{upper}{Upper bound of the data range}

\item{group_by}{Character vector of column names to group by (optional)}

\item{.budget}{Optional privacy budget object to track expenditure}
}
\value{
Data frame with (possibly grouped) private means
}
\description{
Computes a differentially private mean of a numeric column.
}
\examples{
data <- data.frame(city = c("NYC", "LA", "NYC", "LA"),
                   income = c(50000, 60000, 70000, 80000))
data \%>\% dp_mean("income", epsilon = 0.1, lower = 0, upper = 200000, group_by = "city")
}
