% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wrds_connection.R
\name{get_wrds_connection}
\alias{get_wrds_connection}
\title{Establish a Connection to the WRDS Database}
\usage{
get_wrds_connection()
}
\value{
An object of class \code{DBIConnection} representing the connection to the
WRDS database. This object can be used with other DBI-compliant functions
to interact with the database.
}
\description{
This function establishes a connection to the Wharton Research Data Services
(WRDS) database using the \code{RPostgres} package. It requires that the
\code{RPostgres} package is installed and that valid WRDS credentials are set as
environment variables.
}
\details{
The function checks if the \code{RPostgres} package is installed before
attempting to establish a connection. It uses the host, dbname, port, and
sslmode as fixed parameters for the connection. Users must set their WRDS
username and password as environment variables \code{WRDS_USER} and
\code{WRDS_PASSWORD}, respectively, before using this function.
}
\examples{
\dontrun{
  # Before using this function, set your WRDS credentials:
  # Sys.setenv(WRDS_USER = "your_username", WRDS_PASSWORD = "your_password")

  # con <- get_wrds_connection()
  # Use `con` with DBI-compliant functions to interact with the WRDS database
  # Remember to disconnect after use:
  # disconnect_connection(con)
}
}
\seealso{
\code{\link[RPostgres]{Postgres}}, \code{\link[DBI]{dbDisconnect}} for more
information on managing database connections.
}
