% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utf8.R
\name{utf8_encoding}
\alias{utf8_encoding}
\title{Use UTF-8 for character encoding in a data frame}
\usage{
utf8_encoding(.data, .cols)
}
\arguments{
\item{.data}{A data.frame.}

\item{.cols}{The columns you want to convert, usually a character column.}
}
\value{
A data.table with characters in UTF-8 encoding
}
\description{
\code{fread} from \pkg{data.table} could not recognize the encoding
and return the correct form, this could be unconvenient for text mining tasks. The
\code{utf8-encoding} could use "UTF-8" as the encoding to override the current
encoding of characters in a data frame.
}
\examples{
iris \%>\%
  as.data.table() \%>\%
  utf8_encoding(Species)  # could also use `is.factor`
}
