% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_load.R
\name{tt_load}
\alias{tt_load}
\title{Load TidyTuesday data from Github}
\usage{
tt_load(x, week = NULL, files = "All", ..., auth = gh::gh_token())
}
\arguments{
\item{x}{The date of data to pull (in "YYYY-MM-dd" format), or the four-digit
year as a number.}

\item{week}{Which week number to use within a given year. Only used when \code{x}
is a valid year.}

\item{files}{Which file names to download. Default "All" downloads all files
for the specified week.}

\item{...}{Additional parameters to pass to the parsing functions. Note:
These arguments will be passed for all filetypes.}

\item{auth}{A GitHub token. See \code{\link[gh:gh_token]{gh::gh_token()}} for more details.}
}
\value{
\code{tt_data} object, which contains data that can be accessed via \code{$},
and the readme for the week's TidyTuesday, which can be viewed by printing
the object or calling \code{\link[=readme]{readme()}}.
}
\description{
Load TidyTuesday data from Github
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tt_output <- tt_load("2019-01-15")
tt_output
agencies <- tt_output$agencies
\dontshow{\}) # examplesIf}
}
