% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_query.R
\name{tw_query}
\alias{tw_query}
\title{Perform simple Wikidata queries}
\usage{
tw_query(
  query,
  fields = c("item", "itemLabel", "itemDescription"),
  language = tidywikidatar::tw_get_language(),
  return_as_tw_search = TRUE,
  user_agent = tidywikidatar::tw_get_user_agent()
)
}
\arguments{
\item{query}{A list of named vectors, or a data frame (see example and
readme).}

\item{fields}{A character vector of Wikidata fields. Ignored if
\code{return_as_tw_search} is set to \code{TRUE} (as per default). Defaults to
\verb{("item", "itemLabel", "itemDescription")}}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". If more than one, can be set in order of preference, e.g.
\code{c("it", "fr", "en")}. Use "all_available" to keep all languages. For
available language values, see the
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{list
of available language codes in the official documentation}.}

\item{return_as_tw_search}{Logical, defaults to \code{TRUE}. If \code{TRUE}, returns a
data frame with three columns (\code{id}, \code{label}, and \code{description}) that can
be piped to other \code{tw_} functions. If \code{FALSE}, a data frame with as many
columns as fields.}

\item{user_agent}{Defaults to a combination of \code{tidywikidatar} and package
version number. Consider customising it for the current sessions with
\code{\link[=tw_set_user_agent]{tw_set_user_agent()}}, in particular if you are making many queries.}
}
\value{
A data frame
}
\description{
This function aims to facilitate only the most basic type of queries: return
which items have the following property pairs. For more details on Wikidata
queries, the
\href{https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries/examples}{examples
in the official documentation}.
}
\details{
Consider \code{\link[=tw_get_all_with_p]{tw_get_all_with_p()}} if you want to get all items with a given
property, irrespective of the value.
}
\examples{

if (interactive()) {
  query <- list(
    c(p = "P106", q = "Q1397808"),
    c(p = "P21", q = "Q6581072")
  )
  tw_query(query)
}
}
