% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tkBinds}
\alias{tkBinds}
\title{Define Tk Binds To Allow Automatic Resizing}
\usage{
tkBinds(parent, expose = TRUE, configure = TRUE)
}
\arguments{
\item{parent}{parent Tk toplevel window}

\item{expose}{if TRUE update graph when the window is expose}

\item{configure}{if TRUE update the graph when the window is update}
}
\description{
Add binds to automatically resize the graph
}
\details{
This function adds the binds needed to automatically resize the graph
}
\examples{
\dontshow{
if (.isTclImgOk()){
tkbb <- tclVar(1)
tt <- tktoplevel()
tt <- tkRplot(tt, function() {
b <- .tcl2num(tkbb)
 x <- 1:20 / 20
   plot(
   x,
   x ^ b,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", b),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = b)
     points(x,
      x ^ b,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })

     s <-
       tkscale(
       tt,
       from = 0.05,
       to = 2.00,
       variable = tkbb,
       showvalue = FALSE,
       resolution = 0.05,
       orient = "horiz"
       )

       tkpack(s,
       side = "bottom",
       before = tt$env$canvas,
       expand = FALSE,
       fill = "both")

 # to disable the automatic resizing of the graph
   tkBinds(parent = tt, expose = FALSE, configure = FALSE)
 Sys.sleep(1)
 # to enable again the automatic resising
 # tkBinds(parent = tt, expose = TRUE, configure = TRUE)
 Sys.sleep(1)
 tkdestroy(tt)
}
}
\dontrun{
tkbb <- tclVar(1)
tt <- tktoplevel()
tt <- tkRplot(tt, function() {
b <- .tcl2num(tkbb)
 x <- 1:20 / 20
   plot(
   x,
   x ^ b,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", b),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = b)
     points(x,
      x ^ b,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })

       s <-
       tkscale(
       tt,
       from = 0.05,
       to = 2.00,
       variable = tkbb,
       showvalue = FALSE,
       resolution = 0.05,
       orient = "horiz"
       )

       tkpack(s,
       side = "bottom",
       before = tt$env$canvas,
       expand = FALSE,
       fill = "both")

 # to disable the automatic resizing of the graph
   tkBinds(parent = tt, expose = FALSE, configure = FALSE)

 # to enable again the automatic resising
 # tkBinds(parent = tt, expose = TRUE, configure = TRUE)
}
}
