% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_component_functions.R
\name{tm_scale_bar}
\alias{tm_scale_bar}
\title{Map component: scale bar}
\usage{
tm_scale_bar(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=tm_scalebar]{tm_scalebar}}
  \describe{
    \item{\code{breaks}}{breaks. E.g. \code{c(0, 10, 50)} places scale bar breaks at 0, 10, and 50 units. These units are specified in \code{\link[=tm_shape]{tm_shape()}}.}
    \item{\code{width}}{width of the scale bar. Units are number of text line heights, which is similar to the number of characters. In case \code{beaks} are specified, the \code{width} is only handy to finetune the approximated width, e.g. in case clipping of the labels occurs, or there is too much whitespace.}
    \item{\code{allow_clipping}}{should clipping of the last label by allowed? If \code{TRUE} (default), the last break label including unit is printed even when it doesn't fit the frame. If \code{FALSE} it will not be printed. Instead the unit suffix is added to the second last label.}
    \item{\code{text.size}}{text size}
    \item{\code{text.color}}{text.color}
    \item{\code{color.dark}}{color.dark}
    \item{\code{color.light}}{color.light}
    \item{\code{lwd}}{linewidth}
    \item{\code{size}}{Deprecated (use \code{text.size} instead)}
    \item{\code{stack}}{stack with other map components, either \code{"vertical"} or \code{"horizontal"}.}
    \item{\code{margins}}{margins}
    \item{\code{frame}}{frame should a frame be drawn?}
    \item{\code{frame.color}}{frame color}
    \item{\code{frame.alpha}}{frame alpha transparancy}
    \item{\code{frame.lwd}}{frame line width}
    \item{\code{frame.r}}{Radius of the rounded frame corners. 0 means no rounding.}
    \item{\code{bg}}{Show background?}
    \item{\code{bg.color}}{Background color}
    \item{\code{bg.alpha}}{Background transparency}
    \item{\code{position}}{The position specification of the component: an object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}. In case multiple components should be combined (stacked), use \code{group_id} and specify \code{component} in \code{\link[=tm_components]{tm_components()}}.}
    \item{\code{group_id}}{Component group id name. All components (e.g. legends, titles, etc) with the same \code{group_id} will be grouped. The specifications of how they are placed (e.g. stacking, margins etc.) are determined in \code{\link[=tm_components]{tm_components()}} where its argument \code{id} should correspond to \code{group_id}.}
    \item{\code{z}}{z index, e.g. the place of the component relative to the other componets}
  }}
}
\description{
This function was renamed to \code{\link[=tm_scalebar]{tm_scalebar()}} in tmap v4.0.
}
\keyword{internal}
