% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/youtokentome.R
\name{bpe_load_model}
\alias{bpe_load_model}
\title{Load a Byte Pair Encoding model}
\usage{
bpe_load_model(file, threads = -1L)
}
\arguments{
\item{file}{path to the model}

\item{threads}{integer with number of CPU threads to use for model processing. If equal to -1 then minimum of the number of available threads and 8 will be used}
}
\value{
an object of class \code{youtokentome} which is a list with elements
\enumerate{
\item{model: an Rcpp pointer to the model}
\item{model_path: the path to the model}
\item{threads: the threads argument}
\item{vocab_size: the size of the BPE vocabulary}
\item{vocabulary: the BPE vocabulary with is a data.frame with columns id and subword}
}
}
\description{
Load a Byte Pair Encoding model trained with \code{\link{bpe}}
}
\examples{
## Reload a model
path  <- system.file(package = "tokenizers.bpe", "extdata", "youtokentome.bpe")
model <- bpe_load_model(path)

## Build a model and load it again

data(belgium_parliament, package = "tokenizers.bpe")
x <- subset(belgium_parliament, language == "french")
model <- bpe(x$text, coverage = 0.999, vocab_size = 5000, threads = 1)
model <- bpe_load_model(model$model_path, threads = 1)

## Remove the model file (Clean up for CRAN)
file.remove(model$model_path)
}
