% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{adaptive_MC_sampling}
\alias{adaptive_MC_sampling}
\title{Perform Adaptive Monte Carlo Sampling (Internal)}
\usage{
adaptive_MC_sampling(
  samples_file,
  dissimilarity_matrix,
  iterations = 1,
  mapping_max_iter,
  relative_epsilon,
  folds = 20,
  num_cores = 1,
  scenario_name,
  verbose = FALSE
)
}
\arguments{
\item{samples_file}{Path to the CSV file with samples for the current job.}

\item{dissimilarity_matrix}{The dissimilarity matrix to be fitted.}

\item{iterations}{Number of sampling iterations per job.}

\item{mapping_max_iter}{Maximum optimization iterations for the embedding.}

\item{relative_epsilon}{Convergence threshold for the optimization.}

\item{folds}{Number of cross-validation folds.}

\item{num_cores}{Number of cores for parallel processing.}

\item{scenario_name}{Name for output files, used for context.}

\item{verbose}{Logical. If TRUE, prints progress messages.}
}
\value{
A \code{data.frame} containing all samples (initial and newly generated)
with their parameters and evaluated performance metrics. The data frame includes
columns for the log-transformed parameters, \code{Holdout_MAE}, and \code{NLL}.
Returns \code{NULL} if the results file was not created.
}
\description{
Core implementation of the adaptive Monte Carlo sampling algorithm. This internal
function explores the parameter space by updating the sampling distribution
based on evaluated likelihoods. It is called by the main \code{run_adaptive_sampling}
function.
}
\keyword{internal}
