% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{create_diagnostic_plots}
\alias{create_diagnostic_plots}
\title{Create Diagnostic Plots for Multiple Sampling Chains}
\usage{
create_diagnostic_plots(
  chain_files,
  mutual_size = 2000,
  output_file = "diagnostic_plots.png",
  output_dir,
  save_plot = FALSE,
  width = 3000,
  height = 3000,
  res = 300
)
}
\arguments{
\item{chain_files}{A character vector of paths to CSV files, where each file contains data for one chain.}

\item{mutual_size}{Integer. The number of samples to use from the end of each chain for plotting.}

\item{output_file}{Character. The path for saving the plot. Required if \code{save_plot} is TRUE.}

\item{output_dir}{Character. The directory for saving output files. Required if \code{save_plot} is TRUE.}

\item{save_plot}{Logical. If TRUE, saves the plot to a file. Default: FALSE.}

\item{width, height, res}{Numeric. The dimensions and resolution for the saved plot.}
}
\value{
A \code{ggplot} object of the combined plots.
}
\description{
Creates trace and density plots for multiple sampling or optimization chains to help
assess convergence and mixing. It displays parameter trajectories and their
distributions across all chains.
}
\examples{
# This example uses sample data files that would be included with the package.
chain_files <- c(
  system.file("extdata", "diag_chain1.csv", package = "topolow"),
  system.file("extdata", "diag_chain2.csv", package = "topolow"),
  system.file("extdata", "diag_chain3.csv", package = "topolow")
)

# Only run the example if the files are found
if (all(nzchar(chain_files))) {
  # Create diagnostic plot without saving to a file
  create_diagnostic_plots(chain_files, mutual_size = 50, save_plot = FALSE)
}

}
