% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{gof}
\alias{gof}
\title{Goodness of fit based on left-truncated regression model}
\usage{
gof(x, B = 200, P = 1)
}
\arguments{
\item{x}{an object of class \code{trSurvfit} returned by the \code{trSurvfit()} or the \code{trReg()} function or a survival object returned by the \code{Surv()}.}

\item{B}{an integer value specifies the bootstrap size for the left-truncated regression model. A value greater than 2 is required.}

\item{P}{an integer value specifies number of breakpoints to test the linearity of the transformation model.
When \code{P > 0}, \eqn{P} breakpoints divides the event times into \eqn{P} equal spaced segments.
Piecewise linear function constructed from those segments of event times  are used in the left-truncated regression model,
and the overall significance testing if the coefficient estimates are equal is reported. 
Default value for \code{P} is 1. See \bold{Details} for a description of the goodness of fit procedure.}
}
\value{
A list containing the following elements
\describe{
  \item{coefficients}{the regression coefficients of the left-truncated regression model.}
  \item{pval}{the p-value for the equality of the piecewise linearity terms in the expanded model. See \bold{Details}.}
  \item{input}{the class of the inputted object, \code{x}.}
  \item{dat.gof}{a data frame used in fitting the inputted model \code{x}.}
}
}
\description{
Provide goodness-of-fit diagnostics for the transformation model.
}
\details{
The goodness of fit assessment of the transformation model focus on the structure of the
transformation model, which has the form:
\deqn{h(U) = (1 + a)^{-1} \times (h(T) + ah(X)),}
where \eqn{T} is the truncation time, \eqn{X} is the observed failure time,
\eqn{U} is the transformed truncation time that is quasi-independent from \eqn{X} and
\eqn{h(\cdot)} is a monotonic transformation function.
With the condition, \eqn{T < X}, assumed to be satisfied,
the structure of the transformation model implies
\deqn{X - T = -(1 + a) E(U) + (1 + a) X - (1 + a) \times [U - E(U)] := \beta_0 + \beta_1X + \epsilon.}
The regression estimates can be obtained by the left-truncated regression model (Karlsson and Lindmark, 2014).
To evaluate the goodness of fit of the transformation model,
the \code{gof()} function directly test the linearity in \eqn{X} by considering larger model that are nonlinear in \eqn{X}.
In particular, we expand the covariates \eqn{X} to \code{P} piecewise linearity terms and test for equality of the associated coefficients.
}
\examples{
data(channing, package = "boot")
chan <- subset(channing, entry < exit)
fit <- trReg(Surv(entry, exit, cens) ~ sex, data = chan)
gof(fit, B = 10)
}
\references{
Karlsson, M., Lindmark, A. (2014) truncSP: An R Package for Estimation of Semi-Parametric Truncated Linear Regression Models, \emph{Journal of Statistical Software}, \bold{57} (14), pp 1--19.
}
