% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr.R
\name{ckd_epi}
\alias{ckd_epi}
\title{eGFR by CKD-EPI equation}
\usage{
ckd_epi(creat, age, sex, ethnicity, units = "SI", offset = 0)
}
\arguments{
\item{creat}{numeric vector of serum creatinine in µmol/l (or mg/dl if units = "US")}

\item{age}{numeric vector of age in years (accepts integers or decimals)}

\item{sex}{character vector of sex ("F" for female, "M" for male)}

\item{ethnicity}{character vector of patient ethnicity, one of "black" or "non-black"}

\item{units}{non-vectorised optional parameter for creatinine unit ("SI" for µmol/l (default), "US" for mg/dl)}

\item{offset}{non-vectorised optional numeric parameter for offset in years}
}
\value{
a numeric vector of eGFR values
}
\description{
A vectorised function to calculate estimated glomerular filtration rate using the CKD-EPI
equation. By default the equation accepts serum creatinine in µmol/l but can be changed to
mg/dl by setting the units parameter to "US". To allow for serial measurements over time, such as
for transplant follow-up data, there is an optional offset = n parameter which increases the age
value used in the equation by n years.
}
\details{
Reference: Levey AS, Stevens LA, Schmid CH, et al. A new equation to estimate glomerular filtration
rate. Ann Intern Med 2009; 150(9):604-612.
}
\examples{
ckd_epi(creat = 120, age = 45.2, sex = "M", ethnicity = "non-black")
ckd_epi(creat = 1.5, age = 64.3, sex = "F", ethnicity = "black", units = "US")
}
