% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_ittate.R
\name{transport_ittate}
\alias{transport_ittate}
\title{Transported Intent-to-Treat Average Treatment Effect}
\usage{
transport_ittate(
  data,
  instrument,
  trt,
  outcome,
  covar,
  pop,
  obs = NULL,
  id = NULL,
  weights = NULL,
  learners_instrument = "glm",
  learners_trt = "glm",
  learners_pop = "glm",
  learners_outcome = "glm",
  folds = 1,
  control = transport_control()
)
}
\arguments{
\item{data}{[\code{data.frame}]\cr
A \code{data.frame} in containing all necessary variables for the estimation problem.}

\item{instrument}{[\code{character(1)}]
The column name of the randomization variable. This variable must be binary (0/1).}

\item{trt}{[\code{character(1)}]
The column name of the treatment variable. This variable must be binary (0/1).}

\item{outcome}{[\code{character(1)}]\cr
The column name of the outcome variable. This variable must be binary (0/1) or numeric.}

\item{covar}{[\code{character}]\cr
An optional vector containing the column names of covariates to be
included for adjustment.}

\item{pop}{[\code{character(1)}]\cr
The column name of the population indicator variable.
This variable must be binary (0/1) with 0 indicating the target population and 1 the source population.}

\item{obs}{[\code{character(1)}]\cr
An optional column name for a censoring indicator the same. If missingness in the outcome is
present, must be provided. This variable must be binary (0/1) with 1 indicating that the outcome is observed.}

\item{id}{[\code{character(1)}]\cr
An optional column name containing cluster level identifiers.}

\item{weights}{[\code{character(1)}]\cr
An optional column name containing sampling weights. Currently not used.}

\item{learners_instrument}{[\code{character}]\cr
A vector of \code{mlr3superlearner} algorithms for estimation of the propensity score of the instrument.}

\item{learners_trt}{[\code{character}]\cr
A vector of \code{mlr3superlearner} algorithms for estimation of the propensity score of the treatment.}

\item{learners_pop}{[\code{character}]\cr
A vector of \code{mlr3superlearner} algorithms for estimation of the population mechanism.}

\item{learners_outcome}{[\code{character}]\cr
A vector of \code{mlr3superlearner} algorithms for estimation of the outcome regression.}

\item{folds}{[\code{integer(1)}]\cr
The number of folds to be used for cross-fitting.}

\item{control}{[\code{list()}]\cr
Output of \code{transport_control()}.}
}
\value{
An object of class \code{transported_ittate} containing the parameter estimate.
}
\description{
Implements a TMLE for the transported intent-to-treat average treatment effect.
Nuisance parameters are estimated using the Super Learner algorithm.
}
\examples{
gendata <- function(n, A = NULL, S = NULL) {
  if (is.null(S)) S <- rbinom(n, 1, 0.5)
  W1 <- rbinom(n, 1, 0.4 + (0.2 * S))
  W2 <- rnorm(n, 0.1 * S, 1)
  W3 <- rnorm(n, 1 + (0.2 * S), 1)
  if (is.null(A)) A <- rbinom(n, 1, 0.5)
  Z <- rbinom(n, 1, plogis(-log(1.6) + log(4)*A - log(1.1)*W2 - log(1.3)*W3))
  Yi <- rbinom(n, 1, plogis(log(1.6) + log(1.9)*Z - log(1.3)*W3 - log(1.2)*W1 + log(1.2)*W1*Z))
  Y <- ifelse(S == 1, Yi, NA_real_)

  data.frame(W1 = W1, W2 = W2, W3 = W3,
             S = S,
             A = A,
             Z = Z,
             Y = Y,
             Yi = Yi)
}

set.seed(123)
n <- 1000

tmp <- gendata(n)

if (requireNamespace("ranger", quietly = TRUE)) {
  transport_ittate(data = tmp,
                   trt = "Z",
                   instrument = "A",
                   outcome = "Y",
                   covar = c("W1", "W2", "W3"),
                   pop = "S",
                   folds = 1)
}
}
