\name{trc_cor_test}
\alias{trc_cor_test}
\title{
Procedure for calculating p-values}
\usage{
trc_cor_test(X,Y, nperm=10000,start=3,range_m=0.8, span=0.5, seed=21, m0=NULL)
}
\arguments{
  \item{X}{An observed data vector from the first condition.}

  \item{Y}{An observed data vector from the second condition.}

  \item{nperm}{the number of permutations to estimate the null distribution (default: 10000).}
  
  \item{start}{A lower bound of a search region for the threshold rank m (default: 3).}
  
  \item{range_m}{A proportion of length of X for specifying the end of the search region for m
  (default: 0.8).}
    
  \item{span}{A parameter alpha which controls the degree of smoothing in loess function  (default: 0.5).}
  
  \item{seed}{An initial seed for the permutation
   (default: 21).}

  \item{m0}{a specific m value for p-value of the TRC tau with m (defalut: NULL (not reported)).}
}

\value{
  \item{measure}{a vector of calculated Pearson's rho, Kendall's tau, and TRC tau with m chosen by the proposed rule if m0 = NULL; a vector of calculated Pearson's rho, Kendall's tau, TRC tau with m0, TRC tau with m chosen by the proposed rule if m0 is specified.}

  \item{p_val}{a vector of p-values for Pearson's rho, Kendall's tau, and TRC tau with m chosen by the proposed rule if m0 = NULL; a vector of p-values for Pearson's rho, Kendall's tau, TRC tau with m0, TRC tau with m chosen by the proposed rule if m0 is specified.}

  \item{chs_m}{the chosen m value by the proposed procedure.}

  \item{mean_perm_trc}{a mean value of the estimated null distribution of TRC tau by permutation.}
}
\description{
Procedure for calculating p-values of Pearson's rho, Kendall's tau, TRC tau 
for two-sided test for the null hypothesis correaltion is equal to 0
based on the estimated null distribution by permutation.
}

\details{
The p-values are caculated based on 
the estimated null distributions of the TRC tau with a given
m value, the Kendall's tau, and 
Pearson's correlation with the permuted samples,
respectively.
}

\references{
Lim, J., Yu, D., Kuo, H., Choi, H., and Walmsely, S. (2019).
Truncated Rank Correlation as a robust
measure of test-retest reliability
in mass spectrometry data. Statistical Applications in Genetics and Molecular Biology, 18(4).
}

\examples{
%
p = 100
sig_z = 1.15
sig_e = 1
mu_z = 2
mu_e = 8
m0 = 30

S1 = rnorm(p,mean=mu_e,sd=sig_e)
S2 = rnorm(p,mean=mu_e,sd=sig_e)
    
if(m0!=0)
{
   X = mu_z + rnorm(m0,mean=0,sd=sig_z)
   indx = 1:p
   s_indx = sort(sample(indx,m0))
   S1[s_indx] = S1[s_indx] + X
   S2[s_indx] = S2[s_indx] + X
}
      
S1 = exp(S1)
S2 = exp(S2)

trc_cor_test(S1,S2, nperm=1000,start=3,range_m=0.8, span=0.2, seed=21, m0=NULL)


}

