% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDIoob.R
\name{MDIoobTree}
\alias{MDIoobTree}
\alias{MDIoob}
\title{Debiased Mean Decrease in Impurity}
\usage{
MDIoobTree(tidy.RF, tree, trainX, trainY)

MDIoob(tidy.RF, trainX, trainY)
}
\arguments{
\item{tidy.RF}{A tidy random forest. The random forest to calculate MDI-oob
from.}

\item{tree}{An integer. The index of the tree to look at.}

\item{trainX}{A data frame. Train set features, such that the \code{T}th
tree is trained with \code{X[tidy.RF$inbag.counts[[T]], ]}.}

\item{trainY}{A data frame. Train set responses, such that the \code{T}th
tree is trained with \code{Y[tidy.RF$inbag.counts[[T]], ]}.}
}
\value{
A matrix. The content depends on the type of the response.
  \itemize{
    \item Regression: A P-by-1 matrix, where P is the number of features in
      \code{X}. The pth row contains the MDI-oob of feature p.
    \item Classification: A P-by-D matrix, where P is the number of features
      in \code{X} and D is the number of response classes. The dth column of
      the pth row contains the MDI-oob of feature p to class d. You can get
      the MDI-oob of each feature by calling \code{rowSums} on the result.
 }
}
\description{
Calculate the MDI-oob feature importance measure.
}
\details{
It has long been known that MDI incorrectly assigns high importance to noisy
features, leading to systematic bias in feature selection. To address this
issue, Li et al. proposed a debiased MDI feature importance measure using
out-of-bag samples, called MDI-oob, which has achieved state-of-the-art
performance in feature selection for both simulated and real data.

See \code{vignette('MDI', package='tree.interpreter')} for more context.
}
\section{Functions}{
\itemize{
\item \code{MDIoobTree}: Debiased mean decrease in impurity within a single tree

\item \code{MDIoob}: Debiased mean decrease in impurity within the whole
forest
}}

\examples{
library(ranger)
rfobj <- ranger(Species ~ ., iris, keep.inbag=TRUE)
tidy.RF <- tidyRF(rfobj, iris[, -5], iris[, 5])
MDIoobTree(tidy.RF, 1, iris[, -5], iris[, 5])
MDIoob(tidy.RF, iris[, -5], iris[, 5])

}
\references{
A Debiased MDI Feature Importance Measure for Random Forests
  \url{https://arxiv.org/abs/1906.10845}
}
\seealso{
\code{\link{MDI}}

\code{vignette('MDI', package='tree.interpreter')}
}
