% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_group_data.R
\encoding{UTF-8}
\name{prepare_group_data}
\alias{prepare_group_data}
\title{Prepare Grouped Data for Statistical Testing}
\usage{
prepare_group_data(df, value_col = ".value", group_col = "jahr")
}
\arguments{
\item{df}{A data.frame or tibble containing the data.}

\item{value_col}{A string indicating the name of the column with values to test.}

\item{group_col}{A string indicating the name of the grouping column.}
}
\value{
A list with the following elements:
\describe{
  \item{df}{The filtered data frame with updated grouping column.}
  \item{vals}{A list of vectors, one per group, containing values.}
  \item{sample_sizes}{A named vector with sample sizes per group.}
  \item{n_groups}{The number of groups remaining after filtering.}
  \item{group_names}{The names of the groups.}
}
}
\description{
This function prepares a dataset for grouped statistical tests by:
- Filtering out NA values in the target variable;
- Dropping empty groups and reporting excluded levels;
- Splitting the values by group and computing sample sizes.

Diese Funktion bereitet Daten fuer gruppierte Tests vor:
- Entfernt fehlende Werte (NA) in der Zielvariablen;
- Entfernt leere Gruppen und gibt eine Warnung aus;
- Teilt die Werte nach Gruppen und berechnet Stichprobengroessen.
}
\details{
Cleans and splits the input data by group, removing missing values and empty groups.
}
