% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_sPwRph2.R
\name{sPwRph2}
\alias{sPwRph2}
\title{Power of testing the secondary hypothesis in partially hierarchical design}
\usage{
sPwRph2(cvec0, cvec1, delta0, delta1, t0, t1, tc0 = t0, tc1 = t1, rho = 0)
}
\arguments{
\item{cvec0}{a vector of critical boundaries for testing H0}

\item{cvec1}{a vector of critical boundaries for testing H1}

\item{delta0}{a value of drift parameter for testing H0}

\item{delta1}{a value of drift parameter for testing H1}

\item{t0}{a vector of information times for H0}

\item{t1}{a vector of information times for H1}

\item{tc0}{a vector of calendar times for H0}

\item{tc1}{a vector of calendar times for H1}

\item{rho}{a value of correlation coefficient between H0 and H1}
}
\value{
a value of the probability that H1 is rejected, the power
}
\description{
This function computes the power of testing the secondary hypothesis in partially hierarchical design.
}
\examples{
alpha <- 0.05
alpha0 <- 0.03
iuse0 <- 4
iuse1h <- 4
iuse1t <- 4
phi0 <- -4
phi1h <- 1
phi1t <- 1
tc0 <- c(3,6,9,12)
tc1 <- c(6,12,18,24)
t0 <- c(0.3,0.6,0.9,1)
t1 <- (1:4)/4
rho <- 0
cvecList0 <- gbounds(t=t0, iuse=iuse0,
    alpha=alpha0, phi=phi0)
cvec0 <- cvecList0$bd
cvecList1 <- sBoundsPh2(alpha, alpha0,
    t0, t1, tc0, tc1,
    rho, iuse0, iuse1h, iuse1t,
    phi0, phi1h, phi1t)
cvec1 <- cvecList1$bd
sPwRph2(cvec0, cvec1,
    delta0=2, delta1=3,
    t0, t1, tc0, tc1,
    rho=0)
}
\references{
Gou, J. (2023). Trigger strategy in repeated tests on multiple hypotheses. \emph{Statistics in Biopharmaceutical Research}, 15(1), 133-140.
Gou, J. (2022). Sample size optimization and initial allocation of the significance levels in group sequential trials with multiple endpoints. \emph{Biometrical Journal}, 64(2), 301-311.
}
