% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{power_calc_difference}
\alias{power_calc_difference}
\title{Estimate power to detect differences in lying between two samples}
\usage{
power_calc_difference(N1, N2 = N1, P, lambda1, lambda2, alpha = 0.05,
  alternative = c("two.sided", "greater", "less"),
  prior = stats::dunif, nsims = 200)
}
\arguments{
\item{N1}{N of sample 1}

\item{N2}{N of sample 2}

\item{P}{Probability of \emph{bad} outcome}

\item{lambda1}{Probability of lying in sample 1}

\item{lambda2}{Probability of lying in sample 2}

\item{alpha}{Significance level}

\item{alternative}{"two.sided", "greater" (sample 1 is greater), or "less". Can be
abbreviated}

\item{prior}{Prior over lambda. A function which takes a vector of values
between 0 and 1, and returns the probability density. The default is
the uniform distribution.}

\item{nsims}{Number of simulations to run}
}
\value{
Estimated power, a scalar between 0 and 1.
}
\description{
Using simulations, estimate power to detect differences in lying
using \code{\link[=compare_dists]{compare_dists()}}, given values for \eqn{\lambda}, the
probability of lying, in each sample.
}
\examples{

power_calc_difference(N1 = 100, P = 0.5, lambda = 0, lambda2 = 0.25)

}
