% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{sigmoid}
\alias{sigmoid}
\title{The sigmoid transformation}
\usage{
sigmoid(lower = 0, upper = 1, ...)
}
\arguments{
\item{lower}{lower bound of the variable.}

\item{upper}{upper bound of the variable.}

\item{...}{not currently used.}
}
\value{
A list with the transform and inverse functions.
}
\description{
The sigmoid function is a smooth, S-shaped function that maps any real-valued input
into a bounded interval, typically  (0,1) . It is widely used in probability modeling,
logistic regression, and neural networks as an activation function.
}
\examples{

y = cumprod(c(1, 1 + rnorm(100,0.01, 0.005)))
B = sigmoid()
yt = B$transform(y)
ye = B$inverse(yt)
}
\author{
Alexios Galanos
}
