% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{tsconvert.tsmodel.distribution}
\alias{tsconvert.tsmodel.distribution}
\alias{tsconvert.tsmodel.distribution_list}
\title{Convert a distribution object to a long form data.table}
\usage{
\method{tsconvert}{tsmodel.distribution}(object, to = "data.table", name = NULL, ...)

\method{tsconvert}{tsmodel.distribution_list}(object, to = "data.table", ...)
}
\arguments{
\item{object}{a \dQuote{tsmodel.distribution} or \dQuote{tsmodel.distribution_list} object.}

\item{to}{output format. Currently only \dQuote{data.table} supported.}

\item{name}{an optional string for the name of the series which will be
added to the table (only for the \dQuote{tsmodel.distribution}, as the list object
is already validated with names).}

\item{...}{not currently used.}
}
\value{
a data.table object
}
\description{
Converts an object of class \dQuote{tsmodel.distribution} or \dQuote{tsmodel.distribution_list}
to a long form data.table object.
}
\examples{
x1 <- matrix(rnorm(100), 10, 10)
colnames(x1) <- as.character(as.Date(1:10, origin = "1970-01-01"))
class(x1) <- "tsmodel.distribution"
head(tsconvert(x1, name = "SeriesA"))
}
