% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluss.R
\name{floss_extract}
\alias{floss_extract}
\title{FLOSS - Extract Segments}
\usage{
floss_extract(.mpac, threshold = 1, exclusion_zone = NULL)
}
\arguments{
\item{.mpac}{a TSMP object of class \code{ArcCount}.}

\item{threshold}{a \code{number}. (Default is \code{1}). Set the maximum value for evaluating semantic changes.
This is data specific. It is advised to check what is 'normal' for your data.}

\item{exclusion_zone}{if a \code{number} will be used instead of embedded value. (Default is \code{NULL}).}
}
\value{
Returns the input \code{.mp} object a new name \code{floss} with the location of semantic
changes and \code{floss_vals} with the normalized arc count value of the semantic change positions.
}
\description{
Extract candidate points of semantic changes.
}
\examples{
data <- mp_fluss_data$tilt_abp$data[1:1000]
w <- 10
mp <- tsmp(data, window_size = w, verbose = 0)
mp <- fluss_cac(mp)
mp <- fluss_extract(mp, 2)
}
\references{
\itemize{
\item Gharghabi S, Ding Y, Yeh C-CM, Kamgar K, Ulanova L, Keogh E. Matrix Profile VIII:
Domain Agnostic Online Semantic Segmentation at Superhuman Performance Levels. In: 2017 IEEE
International Conference on Data Mining (ICDM). IEEE; 2017. p. 117-26.
}

Website: \url{https://sites.google.com/site/onlinesemanticsegmentation/}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other Semantic Segmentations: 
\code{\link{floss}()},
\code{\link{floss_cac}()},
\code{\link{fluss}()},
\code{\link{fluss_cac}()},
\code{\link{fluss_extract}()},
\code{\link{fluss_score}()}
}
\concept{Semantic Segmentations}
