% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{first.event}
\alias{first.event}
\title{first.event}
\usage{
first.event(
  dat,
  id.name,
  outcome.names,
  t1.name,
  append.to.table = FALSE,
  event.name = "first.event"
)
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat, used to
track subjects across multiple rows.}

\item{outcome.names}{A character vector of variable names from dat, expected to be binary,
representing the events of interest. The function determines the first time each outcome
becomes true (1) for each unique id.}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}

\item{append.to.table}{A logical indicating whether to append the calculated first event
times as new columns to the original data.frame (TRUE) or return them as a separate data frame (FALSE).}

\item{event.name}{The name to give the event time columns when they are appended to the data,
specifically for the first event times.}
}
\value{
If append.to.table is FALSE, the function returns a data table with the calculated
times to the first event for each subject and specified outcome, keyed by the id.name. Each
outcome will have its own column named according to the event.name parameter, appended with
the outcome name (e.g., "outcome.first.event" for first event times). If append.to.table
is TRUE, the original data table is returned with these new columns appended. This facilitates
detailed analysis on the timing of first events in relation to the subjects' overall observation
periods within the panel data structure.
}
\description{
Calculates the time to the first occurrence of specified events for each
subject in a panel data structure. This function is particularly useful for longitudinal
data analysis where the timing of first events is crucial for subsequent analyses.
}
