% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{panel.gaps}
\alias{panel.gaps}
\title{panel.gaps}
\usage{
panel.gaps(
  dat,
  id.name = "id",
  t1.name = "t1",
  t2.name = "t2",
  gap.name = "gap_before",
  first.value = 0,
  expected.gap.between = 0
)
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat, used to track
subjects across multiple rows of data.}

\item{t1.name}{The character name of the time variable within dat representing the start
(left endpoint) of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the end
(right endpoint) of observation intervals.}

\item{gap.name}{A character value specifying the name of the new variable to be created that
indicates whether a gap is observed before the record.}

\item{first.value}{The numeric expected beginning time of the observation period for each subject.}

\item{expected.gap.between}{The numeric amount of time expected between the end of one record
and the start of the next; defaults to zero for continuous observation without expected gaps.}
}
\value{
Returns the original data frame with an additional column (named according to the
gap.name parameter) for each record, indicating whether a gap in observation was detected
before that record. The gap flag is determined based on the specified expected beginning time
and the expected gap between records. This enhanced data frame is instrumental for subsequent
analyses that require understanding of observation continuity and identifying subjects with
missing data periods.
}
\description{
Identifies gaps in observation periods within panel data, marking each record
with a flag indicating whether it was preceded by a gap. A gap reflects a missing period
of observation between this and the previous record for a subject, which is crucial for
assessing data integrity and continuity.
}
