% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.cont.R
\name{ps.cont}
\alias{ps.cont}
\title{Gradient boosted propensity score estimation for continuous exposures}
\usage{
ps.cont(
  formula,
  data,
  n.trees = 10000,
  interaction.depth = 3,
  shrinkage = 0.01,
  bag.fraction = 1,
  sampw = NULL,
  print.level = 2,
  verbose = FALSE,
  stop.method = "wcor",
  treat.as.cont = FALSE,
  ...
)
}
\arguments{
\item{formula}{An object of class [formula]: a symbolic
description of the propensity score model to be fit with the treatment
variable on the left side of the formula and the potential confounding
variables on the right side.}

\item{data}{A dataset that includes the treatment as well as the
potential confounding variables.}

\item{n.trees}{Number of gbm iterations passed on to [gbm]. Default: 10000.}

\item{interaction.depth}{A positive integer denoting the tree depth used in
gradient boosting. Default: 3.}

\item{shrinkage}{A numeric value between 0 and 1 denoting the learning rate.
See [gbm] for more details. Default: 0.01.}

\item{bag.fraction}{A numeric value between 0 and 1 denoting the fraction of
the observations randomly selected in each iteration of the gradient
boosting algorithm to propose the next tree. See [gbm] for
more details. Default: 1.0.}

\item{sampw}{Optional sampling weights.}

\item{print.level}{The amount of detail to print to the screen. Default: 2.}

\item{verbose}{If `TRUE`, lots of information will be printed to monitor the
the progress of the fitting. Default: `FALSE`.}

\item{stop.method}{A method or methods of measuring and summarizing balance
across pretreatment variables. Current options are `wcor`, the weighted Pearson
correlation, summarized by using the mean across the pretreatment variables.
Default: `wcor`.}

\item{treat.as.cont}{Used as a check on whether the exposure has greater than
five levels. If it does not and treat.as.cont=FALSE, an error will be
produced. Default: FALSE}

\item{...}{Additional arguments that are passed to ps function.}
}
\value{
Returns an object of class `ps.cont`, a list containing

  * `gbm.obj` The returned [gbm] object.

  * `treat` The treatment variable.

  * `desc` A list containing balance tables for each method selected in
    `stop.methods`. Includes a component for the unweighted
    analysis names \dQuote{unw}. Each `desc` component includes
    a list with the following components

    - `ess` The effective sample size.

    - `n` The number of subjects.

    - `max.wcor` The largest weighted correlation across the covariates.

    - `mean.wcor` The average weighted correlation across the covariates.

    - `rms.wcor` The root mean square of the absolute weighted correlations across the
       covariates.

    - `bal.tab` a (potentially large) table summarizing the quality of the
      weights for balancing the distribution of the pretreatment covariates.
      This table is best extracted using the [bal.table] method.
      See the help for [bal.table] for details.

    - `n.trees` The estimated optimal number of [gbm]
      iterations to optimize the loss function.

 * `ps.den` Denominator values for the propensity score weights.

 * `ps.num` Numerator values for the propensity score weights.

 * `w` The propensity score weights. If sampling weights are given then these
       are incorporated into these weights.

 * `datestamp` Records the date of the analysis.

 * `parameters` Saves the `ps.cont` call.

 * `alerts` Text containing any warnings accumulated during the estimation.

 * `iters` A sequence of iterations used in the GBM fits used by `plot` function.

 * `balance` The balance measures for the pretreatment covariates used in plotting.

 * `sampw` The sampling weights as specified in the `sampw` argument.

 * `preds` Predicted values based on the propensity score model.

 * `covariates` Data frame containing the covariates used in the propensity score model.

 * `n.trees` Maximum number of trees considered in GBM fit.

 * `data` Data as specified in the `data` argument.
}
\description{
`ps.cont` calculates propensity scores using gradient boosted
regression and provides diagnostics of the resulting propensity scores.
}
\examples{
  \dontrun{test.mod <- ps.cont(tss_0 ~ sfs8p_0 + sati_0 + sp_sm_0
          + recov_0 + subsgrps_n + treat, data=dat}

}
\references{
Zhu, Y., Coffman, D. L., & Ghosh, D. (2015). A boosting algorithm for
estimating generalized propensity scores with continuous treatments.
*Journal of Causal Inference*, 3(1), 25-40. \doi{doi:10.1515/jci-2014-0022}
}
\seealso{
[gbm], [plot.ps.cont], [bal.table], [summary.ps.cont]
}
