# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generate ULID
#'
#' `generate()` generates a new [Universally Unique Lexicographically
#' Sortable Identifier](https://github.com/ulid/spec). Several aliases are
#' available for convience and backwards-compatibility.
#'
#' Note that up until release 0.3.1, the implementations had limitations
#' that resulted in second rather than millisecond resolution. This has
#' been addressed for release 0.4.0 and is now supported as expected.
#'
#' @md
#' @param n number of id's to generate (default = `1`)
#' @rdname ulid
#' @export
#' @examples
#' ULIDgenerate()
generate <- function(n = 1L) {
    .Call(`_ulid_generate`, n)
}

#' Unmarshal a ULID into a data frame with timestamp and random bitstring columns
#'
#' @md
#' @param ulids character ULIDs (e.g. created with `generate()`)
#' @export
#' @rdname ulid
#' @return A `data.frame` with two columns `ts` and `rnd`.
#' @examples
#' unmarshal(generate())
unmarshal <- function(ulids) {
    .Call(`_ulid_unmarshal`, ulids)
}

#' Generate ULIDs from timestamps
#'
#' This function generates a new [Universally Unique Lexicographically
#' Sortable Identifier](https://github.com/ulid/spec) from a vector of
#' `POSIXct` timestamps.
#'
#' @md
#' @param tsv vector of `POSIXct` values
#' @export
#' @rdname ulid
#' @examples
#' ts_generate(as.POSIXct("2017-11-01 15:00:00", origin="1970-01-01"))
ts_generate <- function(tsv) {
    .Call(`_ulid_ts_generate`, tsv)
}

