% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_number_assignments.R
\name{calc_number_assignment}
\alias{calc_number_assignment}
\title{Calculate Number of Molecular Formula Assignments per Peak}
\usage{
calc_number_assignment(ms_id, peak_id, mf, ...)
}
\arguments{
\item{ms_id}{A vector containing the mass spectrum ID for each peak.}

\item{peak_id}{A vector containing the peak ID for each peak.}

\item{mf}{Character vector of molecular formula(s)
(e.g., \code{c("C10H23NO4", "C10H24N4O2S")}).}

\item{...}{Additional arguments passed to methods.}
}
\value{
A vector of integer counts representing the number of
molecular formula assignments for each unique combination
of mass spectrum ID, peak ID, and molecular formula.
}
\description{
This function calculates the number of molecular formula (mf) assignments
for each individual peak (peak_id) within a specified mass spectrum (ms_id). It counts
the occurrences of molecular formulas assigned to each peak and returns a vector of
counts corresponding to the number of assignments for each unique combination of
mass spectrum ID, peak ID, and molecular formula.
}
\examples{
ms_ids <- c("file1", "file1", "file2", "file2", "file3")
peak_ids <- c(1, 2, 2, 3, 4)
mfs <- c("C10H10N2O8", "C10H12N2O8", "C10H10N2O8", "C10H11NOS4", "C10H24N4O2S")
n_assignments <- calc_number_assignment(ms_id = ms_ids, peak_id = peak_ids, mf = mfs)
print(n_assignments)

mf_data_demo[, calc_number_assignment(file_id, peak_id, mf)]
}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
\keyword{misc}
\keyword{utils}
