% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_ma_vs_mz.R
\name{uplot_ma_vs_mz}
\alias{uplot_ma_vs_mz}
\title{Plot Mass Accuracy vs m/z}
\usage{
uplot_ma_vs_mz(mfd, ma_col = "ppm", logo = FALSE, plotly = FALSE, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{ma_col}{Character. Column containing mass accuracy (ppm).}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A ggplot or plotly object.
}
\description{
Generates a UME-style scatter plot showing mass accuracy (\code{ppm})
versus mass-to-charge ratio (\code{m/z}).

Summary statistics (median, 2.5\% and 97.5\% quantiles) are displayed
as horizontal reference lines and an annotation panel.

The plot is returned as a \strong{ggplot2 object} by default, with optional
\strong{plotly} conversion for interactivity.
}
\examples{
uplot_ma_vs_mz(mf_data_demo, ma_col = "ppm")

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
