% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bergen.R
\docType{data}
\name{bergen_3}
\alias{bergen_3}
\title{Support colours of the University of Bergen, Norway}
\format{
An object of class \code{character} of length 5.
}
\source{
Colour definitions are based on \href{https://www.uib.no}{UiB}'s 
\href{https://manual.uib.no/en/brand-guide/}{brand guide} (HTML).
}
\usage{
bergen_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{bergen_3} provides five support colours 
of the \href{https://www.uib.no}{University of Bergen}, Norway.
}
\details{
\code{bergen_3} is based on HEX color definitions.


The support colours are used in combination with the main colours and additional colours 
(see \code{\link{bergen_1}} and \code{\link{bergen_2}}), 
and should not be used as bearing colours. 
Examples of use may include details, illustrations, graphs and statistics.

The support colors can be used as bearing colors in connection with activities 
in the peripheral zone of UiB’s operations. 
Contact \href{https://www.uib.no}{UiB}'s Communications Department for clarification.
}
\examples{
bergen_3
unikn::seecol(bergen_3, 
              main = "Support colours of the University of Bergen, Norway")  # view palette

}
\seealso{
\code{\link{bergen_1}} for main colours of the University of Bergen;
\code{\link{bergen_2}} for additional colours of the University of Bergen; 
\code{\link{bergen_4}} for text colours of the University of Bergen; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Norwegian university color palettes: 
\code{\link{bergen_1}},
\code{\link{bergen_2}},
\code{\link{bergen_4}},
\code{\link{oslo}}
}
\author{
\strong{unicol}, 2023-10-11.
}
\concept{Norwegian university color palettes}
\keyword{datasets}
