% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{runif_cube}
\alias{runif_cube}
\alias{runif_in_cube}
\alias{runif_on_cube}
\title{Uniform sampling on/in cube}
\usage{
runif_in_cube(n, d, O = rep(0, d), r = 1)

runif_on_cube(n, d, O = rep(0, d), r = 1)
}
\arguments{
\item{n}{number of simulations}

\item{d}{dimension}

\item{O}{center of the cube}

\item{r}{radius (half-side) of the cube}
}
\value{
The simulations in a \code{n} times \code{d} matrix.
}
\description{
Uniform sampling on or in a cube (arbitrary dimension).
}
\examples{
sims <- runif_on_cube(60, d = 2)
plot(sims, xlim = c(-1,1), ylim = c(-1,1), pch = 19, asp = 1)
\donttest{sims <- runif_in_cube(50, d = 3)
library(scatterplot3d)
scatterplot3d(sims, pch = 19, highlight.3d = TRUE, asp = 1)}
}
