% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniVal.R
\name{uniVal}
\alias{uniVal}
\title{uniVal}
\usage{
uniVal(val, b = NULL, corm)
}
\arguments{
\item{val}{Vector of validities of the tests}

\item{b}{Vector of weightings for the validities; must match order of `val`. Default: 1}

\item{corm}{Correlation matrix of the tests; must be square with 1s on the diagonal}
}
\value{
A single value of the class `numeric` representing the unified validity estimate across multiple tests
}
\description{
A function for unifying the correlations of multiple tests with a criterion (i.e., the validity)
}
\examples{
val = c(0.20, 0.40, 0.30)
b = c(1, 1, 1)
corm = matrix(c(1, 0.50, 0.35, 0.50, 1, 0.75, 0.35, 0.70, 1), nrow = 3, ncol = 3)
uniVal(val, b, corm)

}
