\name{ut_cmp_warning}
\alias{ut_cmp_warning}

\title{Test for and compare warnings generated by code}

\description{A helper to catch expected warnings and ensure they match what is expected}

\usage{
  ut_cmp_warning(code, expected_regexp = NULL, expected_count = 1L,
                 ignore.case = FALSE, perl = FALSE, fixed = FALSE)
}

\arguments{
  \item{code}{Code expression to test, should generate one or more warnings}
  \item{expected_regexp}{
    Regular expression(s) that the warning(s) should match.
    If \code{NULL} the warning message will not be checked.
    Multiple regexes can be given as a vector; see details.
  }
  \item{expected_count}{
    The number of warnings that should be issued.
    If \code{NULL} then one or more warnings should be issued.
    Setting \code{expected_count} to zero is not allowed.
  }
  \item{ignore.case}{Passed to \code{\link{grep}}}
  \item{perl}{Passed to \code{\link{grep}}}
  \item{fixed}{Passed to \code{\link{grep}}}
}

\value{
  Returns \code{TRUE} if \code{code} generates warnings that match \code{expected_regexp} and
  \code{expected_count}.
  If \code{code} generates warnings that do not match \code{expected_regexp} and
  \code{expected_count} returns a vector of strings that detail the difference between the expected
  and actual warnings.
  Returns \code{"No warnings issued"} if \code{code} does not generate any warnings.
}

\details{
  If \code{expected_regexp} is a single regular expression, then all warnings must match the
  regular expression.
  If \code{expected_regexp} is a vector then:
  \itemize{
    \item all warnings must match at least one regular expression
    \item all regular expressions must match at least one warning
  }
}

\examples{
ok(ut_cmp_warning({
  warning("Wooooo!")
}, "^woo", ignore.case = TRUE), "Issued a haunting warning")

ok(ut_cmp_warning({
  warning("Woooo!")
  warning("Woooooo!")
}, "^Woo", expected_count = 2L), "Issued two haunting warnings")

ok(ut_cmp_warning({
  warning("Woooo!")
  warning("Boooo!")
}, c("^Woo", "^Boo"), expected_count = 2L), "Issued a haunting and a diapproving warning")

\dontshow{
  # Clear unittest result log, so our unittest failues don't fail example-building
  unittest:::clear_outcomes()
}
}
