% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{normalize_to_range}
\alias{normalize_to_range}
\title{Range normalization}
\usage{
normalize_to_range(x, range = c(0, 1))
}
\arguments{
\item{x}{vector, matrix or data.frame with at least two different elements}

\item{range}{vector of two elements specifying the desired normalized range.
Default value is c(0,1)}
}
\value{
the normalized data
}
\description{
Normalize a vector, matrix or data.frame of numeric values in a specified
range.
}
\examples{
vec = 1:10
normalize_to_range(vec)
normalize_to_range(vec, range = c(-1,1))

mat = matrix(c(0,2,1), ncol = 3, nrow = 4)
normalize_to_range(mat, range = c(-5,5))

}
